<?php
/**
 * Single Product tabs
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : $id=PBHelper::createId('pb_tab'); $option=array(); ?>

	<div class="pb-clear-fix"></div>

	<div class="pb-tab pb-clear-fix" id="<?php echo esc_attr($id); ?>">
		<ul class="pb-reset-list">
			<?php foreach ( $tabs as $key => $tab ) : ?>

				<li class="<?php echo $key ?>_tab">
					<a href="#tab-<?php echo $key ?>"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', $tab['title'], $key ) ?></a>
				</li>

			<?php endforeach; ?>
		</ul>
		<?php foreach ( $tabs as $key => $tab ) : ?>

			<div class="panel entry-content" id="tab-<?php echo $key ?>">
				<?php call_user_func( $tab['callback'], $key, $tab ) ?>
			</div>

		<?php endforeach; ?>
	</div>
	<div class="pb-script-tag">
		<script type="text/javascript">
			jQuery(document).ready(function($)
			{
				$("#<?php echo esc_attr($id); ?>").PBTab(<?php echo json_encode($option); ?>);
			});
		</script>
	</div>

<?php endif; ?>